﻿// Copyright  2004-2007. Adobe Systems Incorporated. All Rights Reserved.
package fl.video {

	/**
	 * The VideoAlign class provides constant values to use for the <code>FLVPlayback.align</code> and
	 * <code>VideoPlayer.align</code> properties.
	 * 
	 * @see FLVPlayback#align
     * @see VideoPlayer#align
     *
     * @langversion 3.0
     * @playerversion Flash 9.0.28.0
	 *  
	 *  @playerversion AIR 1.0

	 *  @productversion Flash CS3
	 */
	public final class VideoAlign {

		/**
         * Specifies that the video is aligned in the center.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const CENTER:String           = "center";

		/**
         * Specifies that the video is aligned at the top.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const TOP:String           = "top";

		/**
         * Specifies that the video is aligned on the left.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const LEFT:String          = "left";

		/**
         * Specifies that the video is aligned at the bottom.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const BOTTOM:String        = "bottom";

		/**
         * Specifies that the video is aligned to the right.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const RIGHT:String         = "right";

		/**
         * Specifies that the video is aligned in the top-left corner.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const TOP_LEFT:String      = "topLeft";

		/**
         * Specifies that the video is aligned in the top-right corner.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const TOP_RIGHT:String     = "topRight";

		/**
         * Specifies that the video is aligned in the bottom-left corner.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const BOTTOM_LEFT:String   = "bottomLeft";

		/**
         * Specifies that the video is aligned in the bottom-right corner.
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static const BOTTOM_RIGHT:String  = "bottomRight";

	} // class VideoAlign

}
